CREATE OR REPLACE VIEW public.v_cupomfiscal_crediario
AS SELECT vd.cd_emp,
    vd.cd_filial,
    vd.dt_vd,
    vd.dt_cad,
    vd.cd_cx,
    vd.cd_vd,
    vd.nr_ecf,
    vd.st_vd,
    tef.cd_adm_cartao AS cd_conv,
    adm.nm_usual AS nm_conv,
    tef.vl_cartao AS vlr_cartao,
    tef.vl_saque_cartao AS vlr_saque,
    adm.parc AS qt_parc,
    tef.cod_rede,
    tef.cod_bandeira,
    tef.cod_modalidade,
    tef.nsu_tef AS nr_transacao,
    tef.nr_autorizacao,
        CASE
            WHEN tef.gerenciador_tef = 1 THEN 'scope'::text
            WHEN tef.trn_pos = 1 THEN 'pos'::text
            ELSE 'sitef'::text
        END AS tef_gateway,
    COALESCE(cred.cd_parc, 1::numeric) AS cd_parc,
    COALESCE(cred.dt_parc, vd.dt_vd) AS dt_parc,
    COALESCE(cred.vl_parc, tef.vl_cartao) AS vlr_parc,
        CASE
            WHEN COALESCE(cred.cd_parc, 0::numeric) = 0::numeric THEN 1
            ELSE 0
        END AS parc_mnt_pdv_erro,
    cred.cgc_cpf,
    cred.nr_fatura,
    COALESCE(vd.flag_consolidado, 0) AS flag_consolidado
   FROM pdv_vd vd
     JOIN pdv_vd_tef tef ON vd.cd_emp = tef.cd_emp AND vd.cd_filial = tef.cd_filial AND vd.cd_vd = tef.cd_vd
     LEFT JOIN rc_adm_cartao adm ON tef.cd_emp = adm.cd_emp AND tef.cd_adm_cartao = adm.cd_adm_cartao
     LEFT JOIN pdv_vd_cred cred ON vd.cd_emp = cred.cd_emp AND vd.cd_filial = cred.cd_filial AND vd.cd_vd = cred.cd_vd
  WHERE vd.st_vd > '-1'::integer::numeric AND adm.tp_adm = 6::numeric AND vd.vlr_cartao > 0::numeric;
